<?php
require 'koneksi.php';

$id_barang   = $_POST['id_barang'];
$kondisi     = ucfirst(strtolower(trim($_POST['kondisi']))); // tetap dipakai untuk logika
$stok_baru   = (int) $_POST['stok'];
$part_number = $_POST['part_number'];
$satuan      = $_POST['satuan'];
$barcode     = $_POST['barcode'];
$id_gudang   = $_POST['id_gudang'];
$tahun       = $_POST['tahun'];

$response = ['success' => false];

// Cek apakah data sudah ada
$query = "SELECT * FROM hasil_opname WHERE id_barang = ? AND id_gudang = ? AND tahun = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("iii", $id_barang, $id_gudang, $tahun);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Data ada → update
    $row = $result->fetch_assoc();

    $stok_lama      = (int) $row['stock_akhir'];
    $stok_total     = $stok_lama + $stok_baru;
    $kondisi_bagus  = (int) $row['kondisi_bagus'];
    $kondisi_rusak  = (int) $row['kondisi_rusak'];

    if ($kondisi == "Bagus") {
        $kondisi_bagus += $stok_baru;
    } elseif ($kondisi == "Rusak") {
        $kondisi_rusak += $stok_baru;
    }

    $update = $conn->prepare("
        UPDATE hasil_opname
        SET stock_akhir = ?, kondisi_bagus = ?, kondisi_rusak = ?
        WHERE id_barang = ? AND id_gudang = ? AND tahun = ?
    ");
    $update->bind_param("iiiiii", $stok_total, $kondisi_bagus, $kondisi_rusak, $id_barang, $id_gudang, $tahun);

    if ($update->execute()) {
        $response['success'] = true;
        $response['redirect'] = "lihat_opname.php?id_gudang=$id_gudang&tahun=$tahun";
    } else {
        $response['message'] = 'Gagal update data!';
    }

} else {
    // Data baru → insert
    $kondisi_bagus = $kondisi == "Bagus" ? $stok_baru : 0;
    $kondisi_rusak = $kondisi == "Rusak" ? $stok_baru : 0;

    $insert = $conn->prepare("
        INSERT INTO hasil_opname
        (id_barang, part_number, satuan, barcode, stock_akhir, kondisi_bagus, kondisi_rusak, id_gudang, tahun)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $insert->bind_param("isssiiiii", $id_barang, $part_number, $satuan, $barcode, $stok_baru, $kondisi_bagus, $kondisi_rusak, $id_gudang, $tahun);

    if ($insert->execute()) {
        $response['success'] = true;
        $response['redirect'] = "lihat_opname.php?id_gudang=$id_gudang&tahun=$tahun";
    } else {
        $response['message'] = 'Gagal simpan data baru!';
    }
}

echo json_encode($response);
?>
