<!--
=========================================================
* Paper Dashboard 2 - v2.0.1
=========================================================

* Product Page: https://www.creative-tim.com/product/paper-dashboard-2
* Copyright 2020 Creative Tim (https://www.creative-tim.com)

Coded by www.creative-tim.com

 =========================================================

* The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
-->
<?php
require '../koneksi.php';

$id_gudang = $_GET['id_gudang'] ?? null;
$tahun     = $_GET['tahun'] ?? null;

if (!$id_gudang || !$tahun) {
    echo "Parameter gudang atau tahun tidak lengkap.";
    exit;
}

// Ambil nama gudang
$sql_gudang = "SELECT nama_gudang FROM gudang_tahun WHERE id_gudang = ? AND tahun = ?";
$stmt_gudang = $conn->prepare($sql_gudang);
$stmt_gudang->bind_param("ss", $id_gudang, $tahun);
$stmt_gudang->execute();
$result_gudang = $stmt_gudang->get_result();
$nama_gudang = ($row = $result_gudang->fetch_assoc()) ? $row['nama_gudang'] : 'Tidak ditemukan';

// Ambil data hasil_opname dengan JOIN ke barang
$sql = "SELECT ho.*, b.nama_barang
        FROM hasil_opname ho
        JOIN barang b ON ho.id_barang = b.id_barang
        WHERE ho.id_gudang = ? AND ho.tahun = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $id_gudang, $tahun);
$stmt->execute();
$result = $stmt->get_result();
?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
    STOCK OPNAME RALIKA (beta)
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700,200" rel="stylesheet" />
  <link href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css" rel="stylesheet">
  <!-- CSS Files -->
  <link href="../assets/css/bootstrap.min.css" rel="stylesheet" />
  <link href="../assets/css/paper-dashboard.css?v=2.0.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>

<body class="">
  <div class="wrapper ">
    <div class="sidebar" data-color="white" data-active-color="danger">
      <div class="logo">
        <a href="https://www.creative-tim.com" class="simple-text logo-mini">
          <div class="logo-image-small">
            <img src="../assets/img/logo-small.png">
          </div>
          <!-- <p>CT</p> -->
        </a>
        <a href="https://www.creative-tim.com" class="simple-text logo-normal">
          Creative Tim
          <!-- <div class="logo-image-big">
            <img src="../assets/img/logo-big.png">
          </div> -->
        </a>
      </div>
      <div class="sidebar-wrapper">
        <ul class="nav">
          <li class="active ">
            <a href="./dashboard.php">
              <i class="nc-icon nc-bank"></i>
              <p>Dashboard</p>
            </a>
          </li>
          <li>
            <a href="./gudang_tahun.php">
              <i class="nc-icon nc-diamond"></i>
              <p>Tambah Data</p>
            </a>
          </li>
          <li>
            <a href="./map.html">
              <i class="nc-icon nc-pin-3"></i>
              <p>Maps</p>
            </a>
          </li>
          <li>
            <a href="./notifications.html">
              <i class="nc-icon nc-bell-55"></i>
              <p>Notifications</p>
            </a>
          </li>
          <li>
            <a href="./user.html">
              <i class="nc-icon nc-single-02"></i>
              <p>User Profile</p>
            </a>
          </li>
          <li>
            <a href="./tables.html">
              <i class="nc-icon nc-tile-56"></i>
              <p>Table List</p>
            </a>
          </li>
          <li>
            <a href="./typography.html">
              <i class="nc-icon nc-caps-small"></i>
              <p>Typography</p>
            </a>
          </li>
          <li class="active-pro">
            <a href="./upgrade.html">
              <i class="nc-icon nc-spaceship"></i>
              <p>Upgrade to PRO</p>
            </a>
          </li>
        </ul>
      </div>
    </div>
    <div class="main-panel">
      <!-- Navbar -->
      <nav class="navbar navbar-expand-lg navbar-absolute fixed-top navbar-transparent">
        <div class="container-fluid">
          <div class="navbar-wrapper">
            <div class="navbar-toggle">
              <button type="button" class="navbar-toggler">
                <span class="navbar-toggler-bar bar1"></span>
                <span class="navbar-toggler-bar bar2"></span>
                <span class="navbar-toggler-bar bar3"></span>
              </button>
            </div>
            <a class="navbar-brand" href="javascript:;">Stock Opname Ralika</a>
          </div>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navigation" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
            <span class="navbar-toggler-bar navbar-kebab"></span>
          </button>
          <div class="collapse navbar-collapse justify-content-end" id="navigation">
            <form>
              <div class="input-group no-border">
                <input type="text" value="" class="form-control" placeholder="Search...">
                <div class="input-group-append">
                  <div class="input-group-text">
                    <i class="nc-icon nc-zoom-split"></i>
                  </div>
                </div>
              </div>
            </form>
            <ul class="navbar-nav">
              <li class="nav-item btn-rotate dropdown">
                <a class="nav-link dropdown-toggle" href="http://example.com" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  <i class="nc-icon nc-bell-55"></i>
                  <p>
                    <span class="d-lg-none d-md-block">Some Actions</span>
                  </p>
                </a>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownMenuLink">
                  <a class="dropdown-item" href="#">Action</a>
                  <a class="dropdown-item" href="#">Another action</a>
                  <a class="dropdown-item" href="#">Something else here</a>
                </div>
              </li>
              <li class="nav-item">
                <a class="nav-link btn-rotate" href="javascript:;">
                  <i class="nc-icon nc-settings-gear-65"></i>
                  <p>
                    <span class="d-lg-none d-md-block">Account</span>
                  </p>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </nav>
      <!-- End Navbar -->
      <div class="content">
        <div class="row">
          <div class="col-md-12">
            <div class="card ">
              <div class="card-body ">
                <h2>Data Hasil Opname</h2>
                <p><strong>Gudang:</strong> <?= htmlspecialchars($nama_gudang) ?> | <strong>Tahun:</strong> <?= htmlspecialchars($tahun) ?></p>
                <a href="export_opname_excel.php?id_gudang=<?= $id_gudang ?>&tahun=<?= $tahun ?>" class="btn btn-success">
                    Download Excel
                </a>
                <a href="form_opname.php?id_gudang=<?= $id_gudang ?>&tahun=<?= $tahun ?>" class="btn btn-success">
                    Input Lagi
                </a>
                <a href="dashboard.php" class="btn btn-success">
                    Beranda
                </a>
              </div>
              <div class="card-body ">
                <div class="table-responsive">
                  <?php if ($result->num_rows > 0): ?>
                  <table class="table">
                    <thead class=" text-primary">
                        <th class="text-center">No.</th>
                        <th class="text-center">Nama Barang</th>
                        <th class="text-center">Part Number</th>
                        <th class="text-center">Stock Awal</th>
                        <th class="text-center">Kondisi Bagus</th>
                        <th class="text-center">Kondisi Rusak</th>
                        <th class="text-center">Stock Akhir</th>
                        <th class="text-center">Satuan</th>
                        <th class="text-center">Barcode</th>
                      </thead>
                  <tbody>
                  <?php $no = 1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td class="text-center"><?= $no++ ?></td>
                        <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                        <td class="text-center"><?= htmlspecialchars($row['part_number']) ?></td>
                        <td class="text-center"><?= htmlspecialchars($row['stock_awal']) ?></td>
                        <td class="text-center"><?= number_format($row['kondisi_bagus'] ?? 0) ?></td>
                        <td class="text-center"><?= number_format($row['kondisi_rusak'] ?? 0) ?></td>
                        <td class="text-center"><?= number_format($row['stock_akhir']) ?></td>
                        <td class="text-center"><?= htmlspecialchars($row['satuan']) ?></td>
                        <td class="text-center"><?= htmlspecialchars($row['barcode']) ?></td>
                    </tr>
                    <?php endwhile; ?>
                  </tbody>
                </table>
              <?php else: ?>
                  <p><em>Tidak ada data opname untuk gudang dan tahun yang dipilih.</em></p>
              <?php endif; ?>
              </div>
              <div class="card-footer ">
                <hr>
                <div class="stats">
                  <i class="fa fa-history"></i> Updated 3 minutes ago
                </div>
              </div>
            </div>
          </div>
        </div>

      <footer class="footer footer-black  footer-white ">
        <div class="container-fluid">
          <div class="row">
            <nav class="footer-nav">
              <ul>
                <li><a href="https://www.creative-tim.com" target="_blank">Creative Tim</a></li>
                <li><a href="https://www.creative-tim.com/blog" target="_blank">Blog</a></li>
                <li><a href="https://www.creative-tim.com/license" target="_blank">Licenses</a></li>
              </ul>
            </nav>
            <div class="credits ml-auto">
              <span class="copyright">
                © <script>
                  document.write(new Date().getFullYear())
                </script>, made with <i class="fa fa-heart heart"></i> by Creative Tim
              </span>
            </div>
          </div>
        </div>
      </footer>
    </div>
  </div>
  <!--   Core JS Files   -->
  <script src="../assets/js/core/jquery.min.js"></script>
  <script src="../assets/js/core/popper.min.js"></script>
  <script src="../assets/js/core/bootstrap.min.js"></script>
  <script src="../assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <!--  Google Maps Plugin    -->
  <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_KEY_HERE"></script>
  <!-- Chart JS -->
  <script src="../assets/js/plugins/chartjs.min.js"></script>
  <!--  Notifications Plugin    -->
  <script src="../assets/js/plugins/bootstrap-notify.js"></script>
  <!-- Control Center for Now Ui Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="../assets/js/paper-dashboard.min.js?v=2.0.1" type="text/javascript"></script><!-- Paper Dashboard DEMO methods, don't include it in your project! -->
  <script src="../assets/demo/demo.js"></script>
  <script>
    $(document).ready(function() {
      // Javascript method's body can be found in assets/assets-for-demo/js/demo.js
      demo.initChartsPages();
    });
  </script>
  <script>
  document.getElementById('modalTambah').addEventListener('show.bs.modal', function () {
    var g = document.getElementById('gudang_id').value;
    var t = document.getElementById('tahun').value;
    if (g) document.getElementById('tambah_gudang').value = g;
    if (t) document.getElementById('tambah_tahun').value = t;
  });
</script>
</body>

</html>
