<?php
require 'koneksi.php';

// Ambil semua nama_gudang unik
$gudang_result = $conn->query("SELECT DISTINCT nama_gudang FROM gudang_tahun ORDER BY nama_gudang ASC");

// Tangkap nama_gudang dan tahun dari GET
$nama_gudang = $_GET['nama_gudang'] ?? null;
$tahun       = $_GET['tahun'] ?? null;

// Ambil tahun berdasarkan nama_gudang jika sudah dipilih
$tahun_result = [];
if ($nama_gudang) {
    $stmt_tahun = $conn->prepare("SELECT DISTINCT tahun FROM gudang_tahun WHERE nama_gudang = ? ORDER BY tahun DESC");
    $stmt_tahun->bind_param("s", $nama_gudang);
    $stmt_tahun->execute();
    $tahun_result = $stmt_tahun->get_result();
}

// Ambil data hasil_opname
$data_opname = [];
$id_gudang_sekarang = null;
if ($nama_gudang && $tahun) {
    $stmt = $conn->prepare("
        SELECT ho.*, b.nama_barang, gt.nama_gudang, gt.id_gudang
        FROM hasil_opname ho
        JOIN barang b ON ho.id_barang = b.id_barang
        JOIN gudang_tahun gt ON ho.id_gudang = gt.id_gudang AND ho.tahun = gt.tahun
        WHERE gt.nama_gudang = ? AND gt.tahun = ?
    ");
    $stmt->bind_param("ss", $nama_gudang, $tahun);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $id_barang = $row['id_barang'];
        $id_gudang_sekarang = $row['id_gudang'];
        $tahun_sekarang = $tahun;
        $tahun_lalu = (string)((int)$tahun - 1);

        // --- SOLUSI FIX ---
        // 1. Ambil id_gudang tahun sebelumnya
        $stmt_gudang_lalu = $conn->prepare("
            SELECT id_gudang FROM gudang_tahun
            WHERE nama_gudang = ? AND tahun = ?
            LIMIT 1
        ");
        $stmt_gudang_lalu->bind_param("ss", $nama_gudang, $tahun_lalu);
        $stmt_gudang_lalu->execute();
        $res_gudang_lalu = $stmt_gudang_lalu->get_result();
        $id_gudang_lalu = $res_gudang_lalu->fetch_assoc()['id_gudang'] ?? null;
        $stmt_gudang_lalu->close();

        $prev_stock_akhir = 0;
        if ($id_gudang_lalu) {
            // 2. Ambil stock_akhir dari hasil_opname tahun sebelumnya
            $stmt_prev = $conn->prepare("
                SELECT stock_akhir
                FROM hasil_opname
                WHERE id_barang = ? AND id_gudang = ? AND tahun = ?
                ORDER BY id_opname DESC
                LIMIT 1
            ");
            $stmt_prev->bind_param("sss", $id_barang, $id_gudang_lalu, $tahun_lalu);
            $stmt_prev->execute();
            $prev_result = $stmt_prev->get_result();
            $prev_stock_akhir = $prev_result->fetch_assoc()['stock_akhir'] ?? 0;
            $stmt_prev->close();
        }

        $row['stock_akhir_lalu'] = $prev_stock_akhir;
        $data_opname[] = $row;
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Dashboard Stock Opname</title>
    <style>
        body { font-family: sans-serif; padding: 20px; }
        form { margin-bottom: 20px; }
        select, button { padding: 5px 10px; margin-right: 10px; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #999; padding: 8px; }
        th { background-color: #eee; }
    </style>
</head>
<body>

<h2>Dashboard Stock Opname</h2>

<form method="GET" action="dashboard.php">
    <label for="nama_gudang">Gudang:</label>
    <select name="nama_gudang" onchange="this.form.submit()" required>
        <option value="">Pilih Gudang</option>
        <?php while ($row = $gudang_result->fetch_assoc()): ?>
            <option value="<?= htmlspecialchars($row['nama_gudang']) ?>" <?= ($nama_gudang == $row['nama_gudang']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($row['nama_gudang']) ?>
            </option>
        <?php endwhile; ?>
    </select>

    <label for="tahun">Tahun:</label>
    <select name="tahun" required>
        <option value="">Pilih Tahun</option>
        <?php if ($tahun_result): ?>
            <?php while ($row = $tahun_result->fetch_assoc()): ?>
                <option value="<?= $row['tahun'] ?>" <?= ($tahun == $row['tahun']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($row['tahun']) ?>
                </option>
            <?php endwhile; ?>
        <?php endif; ?>
    </select>

    <button type="submit">Cari</button>
</form>

<?php if ($nama_gudang && $tahun): ?>
    <?php if (count($data_opname) > 0): ?>
        <h3>Hasil Opname Gudang <?= htmlspecialchars($nama_gudang) ?> - Tahun <?= htmlspecialchars($tahun) ?></h3>

        <form method="GET" action="export_opname_excel.php" target="_blank">
            <input type="hidden" name="id_gudang" value="<?= htmlspecialchars($id_gudang_sekarang) ?>">
            <input type="hidden" name="nama_gudang" value="<?= htmlspecialchars($nama_gudang) ?>">
            <input type="hidden" name="tahun" value="<?= htmlspecialchars($tahun) ?>">
            <button type="submit">📥 Download Excel</button>
        </form>

        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Barang</th>
                    <th>Part Number</th>
                    <th>Stock Awal</th>
                    <th>Kondisi Bagus</th>
                    <th>Kondisi Rusak</th>
                    <th>Stock Akhir</th>
                    <th>Satuan</th>
                    <th>Barcode</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; foreach ($data_opname as $row): ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                        <td><?= htmlspecialchars($row['part_number']) ?></td>
                        <td><?= htmlspecialchars($row['stock_akhir_lalu']) ?></td>
                        <td><?= number_format($row['kondisi_bagus'] ?? 0) ?></td>
                        <td><?= number_format($row['kondisi_rusak'] ?? 0) ?></td>
                        <td><?= htmlspecialchars($row['stock_akhir']) ?></td>
                        <td><?= htmlspecialchars($row['satuan']) ?></td>
                        <td><?= htmlspecialchars($row['barcode']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p><em>Tidak ada data opname untuk gudang dan tahun yang dipilih.</em></p>
    <?php endif; ?>
<?php endif; ?>

</body>
</html>
